/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import zigen.plugin.db.ext.s2jdbc.Activator;

public class DtoWizardPage extends WizardPage implements SelectionListener {

    private static final int LEVEL_FIELD_WIDTH = 200;

    private static final int TEXT_FIELD_WIDTH = 200;

    private final String LINE_SEP = System.getProperty("line.separator"); //$NON-NLS-1$

    private TreeViewer viewer;

    /**
     * クエリー名
     */
    Text nameText;

    private Button checkInterface;

    private Button checkBase;

    private Button checkImpl;

    private Button checkVo;

    private Button checkTest;

    private PackageFragment packageFragment;

    private String defaultTableName;

    private static final String title = Messages.getString("DtoWizardPage.1"); //$NON-NLS-1$

    public static final String MSG = Messages.getString("DtoWizardPage.2"); //$NON-NLS-1$

    public DtoWizardPage() {
        super(title);
        setTitle(Messages.getString("DtoWizardPage.3")); //$NON-NLS-1$
        setDescription(MSG);
        setPageComplete(false);
    }

    public DtoWizardPage(String tableName) {
        this();
        this.defaultTableName = tableName;
    }

    protected boolean checkInput() {

        if ("" == nameText.getText().trim()) //$NON-NLS-1$
            return false;

        // if (!checkInterface.getSelection() && !checkBase.getSelection() &&
        // !checkImpl.getSelection() && !checkVo.getSelection() &&
        // !checkTest.getSelection()) {
        // return false;
        // }

        if (packageFragment == null)
            return false;

        return true;

    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);
        // 1分割、false:均等にしない
        container.setLayout(new GridLayout(1, false));

        addNameSection(container);
        // addMemoSection(container);

        Label label = new Label(container, SWT.NULL);
        label.setText(Messages.getString("DtoWizardPage.5")); //$NON-NLS-1$
        addPackageSelection(container);

        // addTargetSection(container);

        setControl(container);
    }

    protected void addNameSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        String label = Messages.getString("DtoWizardPage.6"); //$NON-NLS-1$
        if (defaultTableName != null && !"".equals(defaultTableName)) { //$NON-NLS-1$
            label = Messages.getString("DtoWizardPage.8"); //$NON-NLS-1$
        }

        Label nameLabel = new Label(composite, SWT.NONE);
        nameLabel.setText(label);
        nameLabel.setLayoutData(getGridData(LEVEL_FIELD_WIDTH));
        nameText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        nameText.setText(""); //$NON-NLS-1$
        if (defaultTableName != null && !"".equals(defaultTableName)) { //$NON-NLS-1$
            nameText.setText(defaultTableName);
            nameText.setEnabled(false);
        }

        nameText.setLayoutData(getGridData(TEXT_FIELD_WIDTH - 20));
        // フォーカス時に入力文字列を選択状態とする
        nameText.addFocusListener(new TextSelectionListener());
        nameText.addVerifyListener(new VerifyListener() {

            public void verifyText(VerifyEvent e) {
                verifyHandler(e);
            }
        });
        nameText.addKeyListener(new KeyAdapter() {

            public void keyReleased(KeyEvent e) {
                setPageComplete(checkInput());
            }
        });
    }

    // protected void addMemoSection(Composite parent) {
    // Composite composite = createDefaultComposite(parent);
    // Label dummy = new Label(composite, SWT.NONE);
    // dummy.setText("");
    // dummy.setLayoutData(getGridData(LEVEL_FIELD_WIDTH));
    // Label nameLabel2 = new Label(composite, SWT.NONE);
    // nameLabel2.setText("※名前にはSuffix(Dto)は付けないでください");
    // nameText.setLayoutData(getGridData(TEXT_FIELD_WIDTH - 20));
    //
    // }

    protected void addTargetSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label nameLabel = new Label(composite, SWT.NONE);
        nameLabel.setText(Messages.getString("DtoWizardPage.11")); //$NON-NLS-1$
        nameLabel.setLayoutData(getGridData(LEVEL_FIELD_WIDTH));

        Composite c = new Composite(composite, SWT.NONE);
        c.setLayout(new GridLayout(5, false));

        checkInterface = new Button(c, SWT.CHECK);
        checkInterface.setText(Messages.getString("DtoWizardPage.12")); //$NON-NLS-1$
        checkBase = new Button(c, SWT.CHECK);
        checkBase.setText(Messages.getString("DtoWizardPage.13")); //$NON-NLS-1$
        checkImpl = new Button(c, SWT.CHECK);
        checkImpl.setText(Messages.getString("DtoWizardPage.14")); //$NON-NLS-1$
        checkVo = new Button(c, SWT.CHECK);
        checkVo.setText(Messages.getString("DtoWizardPage.15")); //$NON-NLS-1$
        checkTest = new Button(c, SWT.CHECK);
        checkTest.setText(Messages.getString("DtoWizardPage.16")); //$NON-NLS-1$

        checkInterface.addSelectionListener(this);
        checkBase.addSelectionListener(this);
        checkImpl.addSelectionListener(this);
        checkVo.addSelectionListener(this);
        checkTest.addSelectionListener(this);

        checkInterface.setSelection(true);
        checkBase.setSelection(true);
        checkImpl.setSelection(true);
        checkVo.setSelection(true);
        checkTest.setSelection(true);

        if (defaultTableName == null || "".equals(defaultTableName)) { //$NON-NLS-1$
            checkBase.setSelection(false);
            checkBase.setEnabled(false);
            // checkBase.setVisible(false);
        }
        ;

    }

    public void widgetSelected(SelectionEvent e) {
        setPageComplete(checkInput());
    }

    private void addPackageSelection(Composite parent) {
        // デフォルトのメッセージ
        // super.setMessage(Messages.getString(Messages.getString("DtoWizardPage.2")), IMessageProvider.NONE); //$NON-NLS-1$

        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        FillLayout layout = new FillLayout();
        composite.setLayout(layout);

        // // パスを表示するためのテキストボックス
        // text = new Text(composite, SWT.BORDER);
        // text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        // text.setEditable(false);

        // ツリーの作成
        viewer = new TreeViewer(composite, SWT.BORDER);

        // Javaプロジェクト表示の設定
        viewer.setContentProvider(new StandardJavaElementContentProvider());

        // フィルタの設定
        viewer.addFilter(new SourceDirViewerFilter());

        // ソータの設定
        viewer.setSorter(new JavaProjectSorter());

        // ラベルプロバイダーの設定
        JavaElementLabelProvider provider = new JavaElementLabelProvider();
        viewer.setLabelProvider(provider);

        // Javaモデルの設定
        IJavaModel javaModel = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
        viewer.setInput(javaModel);

        // デフォルトプロジェクトが指定されている場合は、展開しておく
        String defaultProject = Activator.getDefault().getDefaultProject();
        if (defaultProject != null)
            expandDefaultProject(javaModel, defaultProject);

        // ツリーを選択したときの処理
        viewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                selectionChangeHandler(event);
            }
        });

    }

    private void expandDefaultProject(IJavaModel javaModel, String defaultProject) {
        IJavaProject jProject = javaModel.getJavaProject(defaultProject);

        if (jProject != null && jProject.exists()) {
            IJavaProject myJavaProject = javaModel.getJavaProject(defaultProject);
            viewer.expandToLevel(myJavaProject, 2);

        }
    }

    private void selectionChangeHandler(SelectionChangedEvent event) {
        // 選択したものによって表示するメニューを変更
        Object obj = (Object) ((StructuredSelection) event.getSelection()).getFirstElement();
        if (obj instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject) obj;
        }

        if (obj instanceof PackageFragment) {
            packageFragment = (PackageFragment) obj;
            // getButton(IDialogConstants.OK_ID).setEnabled(true);

        } else {
            packageFragment = null;
            // getButton(IDialogConstants.OK_ID).setEnabled(false);
        }
        setPageComplete(checkInput());

    }

    protected GridData getGridData(int width) {
        GridData gd = new GridData();
        // gd.widthHint = convertWidthInCharsToPixels(width);
        gd.widthHint = width;
        return gd;
    }

    protected void verifyHandler(VerifyEvent event) {
        if (event.character == ',' || event.character == '|') {
            event.doit = false;
        }
    }

    public void validateHandler(TypedEvent event) {
        Text text = (Text) event.widget;
        String value = text.getText();
        if (value.indexOf(",") > 0 || value.indexOf("|") > 0) { //$NON-NLS-1$ //$NON-NLS-2$
            text.setFocus();

        }
    }

    protected class TextSelectionListener implements FocusListener {

        public void focusGained(FocusEvent e) {
            if (e.widget instanceof Text) {
                Text text = (Text) e.widget;
                text.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;

        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout(layout);

        GridData data = new GridData();
        data.verticalAlignment = GridData.FILL;
        data.horizontalAlignment = GridData.FILL;

        composite.setLayoutData(data);

        return composite;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        ;
    }

    public Button getCheckImpl() {
        return checkImpl;
    }

    public Button getCheckBase() {
        return checkBase;
    }

    public Button getCheckInterface() {
        return checkInterface;
    }

    public Button getCheckTest() {
        return checkTest;
    }

    public Button getCheckVo() {
        return checkVo;
    }

    public PackageFragment getPackageFragment() {
        return packageFragment;
    }

    public Text getNameText() {
        return nameText;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.defaultTableName = defaultTableName;
    }
}
